import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(10, 8))
ax.set_xlim(0, 10)
ax.set_ylim(0, 5)
ax.set_aspect('equal')
ax.axis('off')

# Define colors
floor_color = 'lightgrey'
passenger_color = 'lightblue'
fast_elevator_color = 'lightgreen'
slow_elevator_color = 'lightgreen'
full_elevator_color = 'lightcoral'

# Define floor positions
floor_positions = [0, 1, 2, 3, 4]

# Draw floors
for i, pos in enumerate(floor_positions):
    ax.add_patch(patches.Rectangle((0, pos), 10, 1, edgecolor='black', facecolor=floor_color))
    ax.text(0.5, pos + 0.5, f'Floor {i}', va='center', ha='center', fontsize=10, weight='bold')

# Draw passengers
passengers = {
    'p0': (0.5, 0),
    'p1': (1.0, 1),
    'p4': (1.5, 1),
    'p2': (9.2, 2),  # Inside fast1
    'p3': (9.6, 2),  # Inside fast1
    'p5': (0.5, 2),
}

for p, (x, y) in passengers.items():
    ax.add_patch(patches.Rectangle((x, y), 0.4, 0.4, edgecolor='black', facecolor=passenger_color))
    ax.text(x + 0.2, y + 0.2, p, va='center', ha='center', fontsize=8)

# Draw elevators
elevators = {
    'fast0': (8, 3, fast_elevator_color, '0/2'),
    'fast1': (9, 2, full_elevator_color, '2/2'),  # Full because p2 and p3 are on board
    'slow0-0': (7, 0, slow_elevator_color, '0/1'),
    'slow1-0': (7, 2, slow_elevator_color, '0/1'),
}

for e, (x, y, color, status) in elevators.items():
    ax.add_patch(patches.Rectangle((x, y), 0.8, 0.4, edgecolor='black', facecolor=color))
    ax.text(x + 0.4, y + 0.2, f'{e}\n{status}', va='center', ha='center', fontsize=8)

# Create a legend
legend_elements = [
    patches.Patch(facecolor=passenger_color, edgecolor='black', label='Passenger'),
    patches.Patch(facecolor=fast_elevator_color, edgecolor='black', label='Fast Elevator (Available)'),
    patches.Patch(facecolor=slow_elevator_color, edgecolor='black', label='Slow Elevator (Available)'),
    patches.Patch(facecolor=full_elevator_color, edgecolor='black', label='Elevator (Full)')
]

ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.2, 1))

# Save the figure
plt.savefig('<PATH_REMOVED>', bbox_inches='tight')
plt.show()